
/***********************************************************************************************
This do file uses microdata to create adjusted and unadjusted time trend graphs;
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;
estimates clear;
version 10;

global data "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/final_data";
global figures "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/figures";

global files "dist_expend";

use "$data/dist_expend.dta", clear;

gen total_rev = tfedrevpp+stlocrevpp;

global outcomes "tcurelscpp tcurinstpp tcurssvcpp tcurothpp total_rev tfedrevpp stlocrevpp salplusben_2009 pup_tch";
global test "salplusben_2009";
global singleoutcome "tcurinstpp";

foreach y in 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 {;
gen yr`y'= fiscalyear==`y';
};

gen exca9901 = yearca==1999 | yearca==2000 | yearca==2001;

/*Create graph of national trends*/

foreach o of global outcomes {;

gen trend_`o'=.;
foreach y in 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 {;
 sum `o' [aw=enrollment] if fiscalyear==`y';
 replace trend_`o' = r(mean) if fiscalyear==`y';
};

preserve;

collapse (firstnm) trend_`o', by(fiscalyear);
if "`o'"=="pup_tch" {;
 scatter trend_`o' fiscalyear, msymbol(circle) mcolor(black) ||,
   ytitle("Students")
   xtitle("Year")
      xline(2002.5, lcolor(black) lpattern(solid))
   xlabel(1994(2)2010)
   legend(off);
   graph export "$figures/National_`o'.eps", replace;
 };
 if "`o'"=="salplusben_2009" {;
 scatter trend_`o' fiscalyear, msymbol(circle) mcolor(black) ||,
   ytitle("2009 dollars (thousands)")
   xtitle("Year")
      xline(2002.5, lcolor(black) lpattern(solid))
   xlabel(1994(2)2010)
   legend(off);
   graph export "$figures/National_`o'.eps", replace;
 };
 else {;
  scatter trend_`o' fiscalyear, msymbol(circle) mcolor(black) ||,
   xtitle("Year")
      xline(2002.5, lcolor(black) lpattern(solid))
   ytitle("2009 dollars per pupil (thousands)")
   xlabel(1994(2)2010)
   legend(off);
   graph export "$figures/National_`o'.eps", replace;
 };
  restore;
  
drop *_`o';

};

/*Run regressions and create graphs showing trend by timing of accountability*/

foreach o of global outcomes {;

gen c_`o' = .;
gen t_`o' = .;

reg `o' yr1996 yr1997 yr1998 yr1999 yr2000 yr2001 yr2002 yr2003 yr2004 yr2005 yr2006 yr2007 yr2008  
  if TREAT==0 & exca9901==0
  [aw=enrollment];
 predict c_b_`o' if fiscalyear==1995 & TREAT==0 & exca9901==0 ;
 sum c_b_`o' if fiscalyear==1995 & TREAT==0 & exca9901==0 [aw=enrollment];
 local cm`o' = r(mean);
 replace c_`o' = `cm`o'' if fiscalyear==1995 & TREAT==0 & exca9901==0 ;
 foreach y in 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008{;
  replace c_`o' = `cm`o'' + _b[yr`y'] if fiscalyear==`y' & TREAT==0  & exca9901==0;
 };
  
reg `o' yr1996 yr1997 yr1998 yr1999 yr2000 yr2001 yr2002 yr2003 yr2004 yr2005 yr2006 yr2007 yr2008 
  if TREAT==1 & exca9901==0  
  [aw=enrollment];
 predict t_b_`o' if fiscalyear==1995 & TREAT==1 & exca9901==0;
 sum t_b_`o' if fiscalyear==1995 & TREAT==1 & exca9901==0 [aw=enrollment];
 local tm_`o' = r(mean);
 replace t_`o' = `tm_`o'' if fiscalyear==1995 & TREAT==1 & exca9901==0;
 foreach y in 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 {;
  replace t_`o' = `tm_`o'' + _b[yr`y'] if fiscalyear==`y' & TREAT==1 & exca9901==0;
 };  
  
preserve;
drop if exca9901==1;
 collapse (firstnm) c_`o' t_`o', by(fiscalyear);
 gen tmpy = .;
if "`o'"=="pup_tch" {;
scatter c_`o' fiscalyear, msymbol(Oh) mcolor(black) ||
 scatter t_`o' fiscalyear, msymbol(triangle) mcolor(black) ||
 lfit c_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy fiscalyear, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy fiscalyear, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   ytitle("Students")
   xtitle("Year")
   xlabel(1994(2)2010)
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/Alldist_`o'.eps", replace;
 };
 if "`o'"=="salplusben_2009" {;
scatter c_`o' fiscalyear, msymbol(Oh) mcolor(black) ||
 scatter t_`o' fiscalyear, msymbol(triangle) mcolor(black) ||
 lfit c_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy fiscalyear, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy fiscalyear, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   ytitle("2009 dollars (thousands)")
   xtitle("Year")
   xlabel(1994(2)2010)
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/Alldist_`o'.eps", replace;
 };
 else {;
 scatter c_`o' fiscalyear, msymbol(Oh) mcolor(black) ||
 scatter t_`o' fiscalyear, msymbol(triangle) mcolor(black) ||
 lfit c_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy fiscalyear, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy fiscalyear, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   xtitle("Year")
   xlabel(1994(2)2010)
   ytitle("2009 dollars per pupil (thousands)")
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/Alldist_`o'.eps", replace;
  };
  restore;
 
 drop *_`o';
 
 };

/*Repeat with only instructional expenditure outcome, breaking the figures down by poverty level*/

estimates clear;

foreach o of global singleoutcome {;
forval n=1/4 {;

gen c_`o'_`n' = .;
gen t_`o'_`n' = .;

reg `o' yr1996 yr1997 yr1998 yr1999 yr2000 yr2001 yr2002 yr2003 yr2004 yr2005 yr2006 yr2007 yr2008 
  if TREAT==0 & pov_quart==`n' & exca9901==0
  [aw=enrollment];
 predict c_b_`o'_`n' if fiscalyear==1995 & TREAT==0 & pov_quart==`n' & exca9901==0;
 sum c_b_`o'_`n' if fiscalyear==1995 & TREAT==0 & pov_quart==`n' & exca9901==0 [aw=enrollment];
 local cm`o'_`n' = r(mean);
 replace c_`o'_`n' = `cm`o'_`n'' if fiscalyear==1995 & TREAT==0 & pov_quart==`n' & exca9901==0;
 foreach y in 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 {;
  replace c_`o'_`n' = `cm`o'_`n'' + _b[yr`y'] if fiscalyear==`y' & TREAT==0 & pov_quart==`n' & exca9901==0;
 };
  
reg `o' yr1996 yr1997 yr1998 yr1999 yr2000 yr2001 yr2002 yr2003 yr2004 yr2005 yr2006 yr2007 yr2008  
  if TREAT==1 & pov_quart==`n' & exca9901==0
  [aw=enrollment];
 predict t_b_`o'_`n' if fiscalyear==1995 & TREAT==1 & pov_quart==`n' & exca9901==0 ;
 sum t_b_`o'_`n' if fiscalyear==1995 & TREAT==1 & pov_quart==`n' & exca9901==0 [aw=enrollment];
 local tm_`o'_`n' = r(mean);
 replace t_`o'_`n' = `tm_`o'_`n'' if fiscalyear==1995 & TREAT==1 & pov_quart==`n' & exca9901==0;
 foreach y in 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 {;
  replace t_`o'_`n' = `tm_`o'_`n'' + _b[yr`y'] if fiscalyear==`y' & TREAT==1 & pov_quart==`n' & exca9901==0;
 };  
  
preserve;
drop if exca9901==1;
 collapse (firstnm) c_`o'_`n' t_`o'_`n', by(fiscalyear pov_quart);
gen tmpy = .;
 scatter c_`o' fiscalyear, msymbol(Oh) mcolor(black) ||
 scatter t_`o' fiscalyear, msymbol(triangle) mcolor(black) ||
 lfit c_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(dash) ||
 lfit c_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(dash) ||
 lfit t_`o' fiscalyear if fiscalyear<2003, lcolor(black) lpattern(solid) ||
 lfit t_`o' fiscalyear if fiscalyear>=2003, lcolor(black) lpattern(solid) ||
 scatter tmpy fiscalyear, msymbol(Oh) connect(direct) lpattern(dash) lcolor(black) mcolor(black) ||
 scatter tmpy fiscalyear, msymbol(triangle) connect(direct) lpattern(solid) lcolor(black) mcolor(black) ||,
   xline(2002.5, lcolor(black) lpattern(solid))
   xtitle("Year")
   xlabel(1994(2)2010)
   ytitle("2009 dollars per pupil (thousands)")
   legend(rows(2) order(7 8) label(7 "State adopted school acct. policy by 1998") 
     label(8 "State never adopted school acct. policy before NCLB"));
   graph export "$figures/quartiles_`o'_`n'.eps", replace;
  restore;
 
 };
 
 drop *_`o'_*;
};

